
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Exam IDs and corresponding scores
exam_ids = np.arange(1, 11)
scores = np.random.uniform(60, 90, 10)
upper_error = np.random.uniform(5, 10, 10)
down_error = np.random.uniform(3, 7, 10)
left_error = [0.2] * 10
right_error = [0.3] * 10

# Chart labels and title
xlabel = "Exam ID"
ylabel = "Score"
title = "Student Performance in Exams"
xhline = 75
label = "Performance Error"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(10, 7))
ax.errorbar(
    exam_ids,
    scores,
    xerr=[left_error, right_error],
    yerr=[down_error, upper_error],
    fmt="o",
    color="#006699",
    ecolor="#FF9933",
    capsize=5,
    label=label,
)
for i, (exam_id, score, uperror, downerror) in enumerate(zip(exam_ids, scores, upper_error, down_error)):
    ax.text(
        exam_id + 0.25, score + 0.5 * uperror, r"$+%.1f$" % (uperror), va="center", ha="center", fontsize=8, color="blue"
    )
    ax.text(
        exam_id + 0.25, score - 0.5 * downerror, r"$-%.1f$" % (downerror), va="center", ha="center", fontsize=8, color="red"
    )
ax.set_title(title, fontsize=16, fontweight='bold')
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.legend(loc='upper right')
ax.axhline(xhline, color="green", linestyle="--", linewidth=2)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorpoint_43.pdf", bbox_inches="tight")
