
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
days = np.arange(1, 11)  # Days 1 to 10
speeds = np.random.uniform(60, 105, 10)  # Speeds in km/h, plausible range for vehicles
left_error = np.random.uniform(3, 7, 10)  # Left error margin
right_error = np.random.uniform(2, 8, 10)  # Right error margin
title = "Vehicle Speeds over 10 Days with Asymmetric Error"
xlabel = "Days"
ylabel = "Speed (km/h)"
legend_label = "Speed with Error Bars"
annotations = [(r"${-%.1f}$" % le, r"${+%.1f}$" % re) for le, re in zip(left_error, right_error)]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(12, 8))

# Optimized error bar plot style
ax.errorbar(
    days,
    speeds,
    xerr=[left_error, right_error],
    fmt="^",
    color="#007acc",  # Blueish color
    ecolor="#ff5733",  # Orange error bars
    capsize=4,
    capthick=2,
    elinewidth=1.5,
    label=legend_label,
)

# Adding annotations for errors
for i, (day, speed, le, re, (left_text, right_text)) in enumerate(zip(days, speeds, left_error, right_error, annotations)):
    ax.text(
        day - 0.8 * le,
        speed + 0.5,
        left_text,
        va="center",
        ha="center",
        color="green",
    )
    ax.text(
        day + 0.8 * re,
        speed + 0.5,
        right_text,
        va="center",
        ha="center",
        color="red",
    )

# Enhancing chart features
ax.set_title(title, fontsize=16, fontweight='bold')
ax.set_xlabel(xlabel, fontsize=14)
ax.set_ylabel(ylabel, fontsize=14)
ax.legend(loc="upper right", fontsize=12)
ax.xaxis.grid(True, linestyle='--', which='both', color='grey', alpha=0.7)
ax.yaxis.grid(True, linestyle='--', which='both', color='grey', alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorpoint_45.pdf", bbox_inches="tight")
