
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)

# Generating data for the transportation domain
road_sections = np.linspace(1, 10, 10)  # Road sections from 1 to 10
average_speeds = np.random.uniform(50, 70, 10)  # Average speeds between 50 to 70 km/h
left_error = np.random.uniform(5, 10, 10)  # Error values (lower bound)
right_error = np.random.uniform(5, 10, 10)  # Error values (upper bound)

title = "Average Speed of Vehicles on Different Road Sections"
xlabel = "Road Section"
ylabel = "Average Speed (km/h)"
legend_label = "Speed with Error"
annotation_texts = ["L", "R"]  # Labels for left and right error

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(10, 7))
ax.errorbar(
    road_sections,
    average_speeds,
    xerr=[left_error, right_error],
    fmt="o",
    color="#1f77b4",
    ecolor="#ff7f0e",
    elinewidth=1.5,
    capsize=3,
    capthick=1.5,
    label=legend_label,
)
for i, (rs, speed, le, re) in enumerate(zip(road_sections, average_speeds, left_error, right_error)):
    ax.text(
        rs - 0.8 * le, 
        speed + 0.5, 
        r"${-%d}$" % (le), 
        va="center", 
        ha="center",
        fontsize=8,
        color="green"
    )
    ax.text(
        rs + 0.8 * re, 
        speed + 0.5, 
        r"${+%d}$" % (re), 
        va="center", 
        ha="center",
        fontsize=8,
        color="red"
    )

# Set chart title and labels
ax.set_title(title, fontsize=14)
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.legend(loc="upper left", fontsize=10)
ax.xaxis.grid(True)
ax.yaxis.grid(True)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorpoint_46.pdf", bbox_inches="tight")
