
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)

labels = ["Philosophy of Mind", "Ethics", "Metaphysics"]

x = np.linspace(2000, 2020, 6)
y1 = np.random.uniform(30, 60, 6)
y2 = np.random.uniform(50, 80, 6)
y3 = np.random.uniform(40, 70, 6)
error1 = [np.random.uniform(5, 10, 6), np.random.uniform(5, 10, 6)]
error2 = [
    np.random.uniform(4, 12, 6),
    np.random.uniform(4, 12, 6),
]  # Symmetric horizontal error
error3 = np.random.uniform(3, 8, 6)
title = "Trends in Philosophical Studies (2000-2020)"
xvline = 2010

xlabel = "Year"
ylabel1 = "Philosophy of Mind Publications"
ylabel2 = "Ethics Publications"
ylabel3 = "Metaphysics Publications"
legendlabel = "Metaphysics Publications"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with three subplots and shared x-axis
fig, (ax0, ax1, ax2) = plt.subplots(figsize=(6, 9), nrows=3, sharex=True)

colors1 = ["#6baed6", "#4292c6", "#2171b5", "#08519c", "#08306b", "#bcbddc"]
colors2 = ["#a1d99b", "#74c476", "#41ab5d", "#238b45", "#005a32", "#e5f5e0"]

# First subplot with symmetric vertical error bars
for i in range(len(x)):
    ax0.errorbar(
        x[i],
        y1[i],
        yerr=[[error1[0][i]], [error1[1][i]]],
        fmt="^",
        color=colors1[i],
        capsize=4,
    )
    ax0.text(x[i] - 0.5, y1[i], f"{y1[i]:.2f}", fontsize=8, ha="right")
ax0.set_title(title)
ax0.axhline(y=45, linestyle="--", color="#192770")
ax0.set_ylabel(ylabel1)
ax0.yaxis.grid(True)
ax0.xaxis.grid(False)

# Second subplot with symmetric horizontal error bars
for i in range(len(x)):
    ax1.errorbar(
        x[i],
        y2[i],
        xerr=[[error2[0][i]], [error2[1][i]]],
        fmt="s",
        color=colors2[i],
        markersize=8,
    )
    ax1.text(x[i] + 0.5, y2[i] + 0.1, f"{y2[i]:.2f}", fontsize=8, ha="left")
ax1.axvline(x=xvline, linestyle="--", color="#265b2b")
ax1.set_ylabel(ylabel2)
ax1.xaxis.grid(True)
ax1.yaxis.grid(False)

# Third subplot with symmetric vertical error bars
ax2.errorbar(x, y3, yerr=error3, fmt="*", color="#d94801", capsize=4)
ax2.set_ylabel(ylabel3)
ax2.legend([legendlabel])
ax2.yaxis.grid(True)
ax2.xaxis.grid(False)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and display the plot
plt.tight_layout()
plt.savefig("errorpoint_48.pdf", bbox_inches="tight")
