
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)

xlabel = "Days of the Week"
ylabel = "Hours Spent"
suptitle = "Media Consumption Trends Over a Week"
labels = ["Streaming", "Social Media", "Gaming"]

days = np.arange(1, 8)  # Representing days of the week
# Random data for hours spent on different media types
streaming_hours = np.random.uniform(2, 5, 7)
social_media_hours = np.random.uniform(1, 4, 7)
gaming_hours = np.random.uniform(0.5, 3, 7)
error1 = [np.random.uniform(0.5, 1.5, 7), np.random.uniform(0.5, 1.5, 7)]
error2 = [
    np.random.uniform(0.2, 0.8, 7),
    np.random.uniform(0.2, 0.8, 7),
]  # Symmetric horizontal error
error3 = np.random.uniform(0.1, 0.5, 7)
xvline = 5

# Chart titles, axis labels, and annotation texts
title = "Symmetric Error in Media Usage"

titles = ["Streaming Hours", "Social Media Hours", "Gaming Hours"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with three subplots and shared x-axis
fig, (ax0, ax1, ax2) = plt.subplots(figsize=(8, 10), nrows=3, sharex=True)

colors1 = ["#ff6f61", "#6b5b95", "#88b04b", "#f7cac9", "#92a8d1", "#955251", "#b565a7"]
colors2 = ["#dd4124", "#009473", "#d65076", "#45b8ac", "#e94b3c", "#2a4b7c", "#d5a6bd"]

# First subplot with symmetric vertical error bars
for i in range(len(days)):
    ax0.errorbar(
        days[i],
        streaming_hours[i],
        yerr=[[error1[0][i]], [error1[1][i]]],
        fmt="o",
        color=colors1[i],
        capsize=4,
    )
    ax0.text(days[i] - 0.2, streaming_hours[i], f"{streaming_hours[i]:.2f}", fontsize=8, ha="right")
ax0.set_title(titles[0])
ax0.axhline(y=3.5, linestyle="--", color="#2a4b7c")
ax0.yaxis.grid(True)
ax0.xaxis.grid(False)

# Second subplot with symmetric horizontal error bars
for i in range(len(days)):
    ax1.errorbar(
        days[i],
        social_media_hours[i],
        xerr=[[error2[0][i]], [error2[1][i]]],
        fmt="s",
        color=colors2[i],
        markersize=8,
    )
    ax1.text(days[i] + 0.2, social_media_hours[i] + 0.1, f"{social_media_hours[i]:.2f}", fontsize=8, ha="left")
ax1.set_title(titles[1])
ax1.axvline(x=xvline, linestyle="--", color="#009473")
ax1.xaxis.grid(True)
ax1.yaxis.grid(False)

# Third subplot with symmetric vertical error bars
ax2.errorbar(days, gaming_hours, yerr=error3, fmt="^", color="#6b5b95", capsize=2)
ax2.set_title(titles[2])
ax2.legend([labels[2]], loc="upper right")
ax2.yaxis.grid(True)
ax2.xaxis.grid(False)

# Set common labels and title
fig.suptitle(suptitle)
plt.xlabel(xlabel)
plt.ylabel(ylabel)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and display the plot
plt.tight_layout(rect=[0, 0.03, 1, 0.95])
plt.savefig("errorpoint_49.pdf", bbox_inches="tight")

