
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
categories = [
    "Solar Efficiency",
    "Wind Energy Output",
    "Hydropower Generation",
    "Thermal Efficiency",
    "Nuclear Performance",
    "Battery Storage",
]

means = np.random.uniform(0.4, 2.5, len(categories))
std_devs = np.random.uniform(0.1, 0.3, len(categories))
dataset_mean = np.mean(means)

# Labels and Plot Types
label_Mean = "Mean Energy Metric"
label_Dataset_mean = "Average Energy Metric"

# Axes Limits and Labels
ylabel_value = "Energy Performance Metric"


title = "Energy Performance by Source"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax = plt.subplots(figsize=(10, 6))
ylim_values = [0.0, 3]
# Error bar plot with optimized style
ax.errorbar(
    categories,
    means,
    yerr=std_devs,
    fmt="o",
    color="blue",
    ecolor="green",
    elinewidth=2,
    capsize=5,
    markerfacecolor="lightblue",
    label=label_Mean,
)

# Dataset mean line
ax.axhline(
    y=dataset_mean,
    color="darkorange",
    linestyle="--",
    linewidth=1.5,
    label=label_Dataset_mean,
)

# Customizing the plot
ax.set_ylabel(ylabel_value, fontsize=12)
ax.set_xticklabels(categories, rotation=45, ha="right", fontsize=10)
ax.legend(fontsize=10)
ax.set_ylim(ylim_values)

# Title for the plot
ax.set_title(title, fontsize=14, fontweight="bold")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to prevent clipping of tick-labels
plt.tight_layout()
plt.savefig("errorpoint_51.pdf", bbox_inches="tight")
