
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for plotting
companies = ["Company A", "Company B", "Company C", "Company D", "Company E"]
annual_revenue = [1.5, 2.1, 1.8, 2.4, 1.9]  # Annual revenue (in billions USD)
std_devs = [0.2, 0.15, 0.1, 0.25, 0.18]  # Standard deviation (in billions USD)
world_mean_revenue = [2.0]  # Global average annual revenue (in billions USD)

xlabel = "Annual Revenue (in billions USD)"
label = "Global Average Annual Revenue"
plot_title = 'Annual Revenue by Company'

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
plt.figure(figsize=(10, 7))  # Adjusting figure size for better readability
plt.errorbar(
    annual_revenue,
    companies,
    xerr=std_devs,
    fmt="o",
    color="#0073e6",  # Blue for markers
    ecolor="#6699cc",  # Light blue for error bars
    capsize=4,
    elinewidth=2,
    markeredgewidth=2,
    label="Company Revenue",
)
plt.axvline(world_mean_revenue[0], color="#ff6600", linestyle="--", linewidth=3, label=label)

# Customizing the plot
plt.xlabel(xlabel)
plt.title(plot_title)
plt.legend(loc='upper right')
plt.grid(True, linestyle='--', linewidth=0.5, alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting the layout and saving the figure
plt.tight_layout()
plt.savefig("errorpoint_55.pdf", bbox_inches="tight")
