
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data
categories = [
    "Email",
    "Social Media",
    "Telephone",
    "Video Call",
    "In-Person",
    "Messaging Apps",
]
avg_users_mean = [120, 200, 75, 80, 60, 150]  # Average number of users
avg_interactions_mean = [300, 450, 200, 250, 100, 350]  # Average number of interactions
avg_users_error = [10, 15, 7, 8, 6, 12]  # Error margins for average users
avg_interactions_error = [30, 45, 20, 25, 10, 35]  # Error margins for average interactions

labels = ["Average Users", "Average Interactions"]
ylabel = "Average Number of Users"
xlabel = "Communication Method"
title = "Average Users and Interactions Across Different Communication Methods"
refline_label = "Average Interactions Reference Line"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, ax = plt.subplots(figsize=(12, 8))

# Users data
ax.errorbar(
    categories,
    avg_users_mean,
    yerr=avg_users_error,
    fmt="o",
    color="mediumseagreen",
    label=labels[0],
    capsize=10,
    markersize=8,
    elinewidth=2,
    markeredgewidth=2,
)

# Interactions data
ax.errorbar(
    categories,
    avg_interactions_mean,
    yerr=avg_interactions_error,
    fmt="s",
    color="royalblue",
    label=labels[1],
    capsize=10,
    markersize=8,
    elinewidth=2,
    markeredgewidth=2,
)

# Customization
ax.set_ylabel(ylabel)
ax.set_xlabel(xlabel)
ax.set_xticklabels(categories, rotation=45, ha="right")

# Reference line for average interactions
avg_interactions_ref = np.mean(avg_interactions_mean)
ax.axhline(
    y=avg_interactions_ref,
    color="grey",
    linestyle="--",
    linewidth=2,
    label=refline_label,
)

# Legend and title
ax.legend()
ax.set_title(title)

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("errorpoint_61.pdf", bbox_inches="tight")
