
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for Energy Domain
categories = [
    "Solar Energy",
    "Wind Energy",
    "Nuclear Energy",
    "Hydropower",
    "Geothermal",
    "Biomass",
]
unique_speaker_mean = [
    65,
    48,
    55,
    60,
    52,
    49,
]
unique_shouter_mean = [
    25,
    20,
    22,
    24,
    19,
    21,
]
unique_speaker_error = [
    6,
    5,
    4.5,
    5.5,
    5,
    4,
]
unique_shouter_error = [
    3,
    2.7,
    2.5,
    2.8,
    2.4,
    2.6,
]
xlabel = categories
ylabel = "Number of Unique Speakers"
axlabel = "Average Unique Shouter Count"
title = "Average Number of Unique Speakers and Shouters in Different Energy Fields"
legendlabels = ["Unique speaker count mean", "Unique shouter count mean"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, ax = plt.subplots(figsize=(12, 8))

# Custom Colors and Markers
ax.errorbar(
    categories,
    unique_speaker_mean,
    yerr=unique_speaker_error,
    fmt="o",
    color="teal",
    label=legendlabels[0],
    capsize=10,
    markersize=8,
    elinewidth=2,
    markeredgewidth=2,
)
ax.errorbar(
    categories,
    unique_shouter_mean,
    yerr=unique_shouter_error,
    fmt="s",
    color="darkorange",
    label=legendlabels[1],
    capsize=10,
    markersize=8,
    elinewidth=2,
    markeredgewidth=2,
)

# Customization
ax.set_ylabel(ylabel)
ax.set_xticklabels(categories, rotation=45, ha="right")

# Adding a horizontal line for mean shouter count
ax.axhline(
    y=np.mean(unique_shouter_mean),
    color="grey",
    linestyle="--",
    linewidth=2,
    label=axlabel,
)

ax.legend()
ax.set_title(title)
plt.tight_layout()

# ===================
# Part 4: Saving Output
# ===================
plt.savefig("errorpoint_62.pdf", bbox_inches="tight")
