
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for Technology domain
categories = [
    "AI",
    "Blockchain",
    "Cloud Computing",
    "Big Data",
    "Cybersecurity",
    "IoT",
]
unique_speaker_mean = [250, 180, 220, 150, 300, 200]  # Mean values for participants
unique_shouter_mean = [
    1800,
    1500,
    1700,
    1200,
    2100,
    1600,
]  # Mean values for audience
unique_speaker_error = [25, 18, 22, 15, 30, 20]  # Error values for participants
unique_shouter_error = [180, 150, 170, 120, 210, 160]  # Error values for audience
labels = ["Participant count mean", "Audience count mean"]
ylabel = "Number of Participants"
axlabel = "Average Audience Count"
title = "Analysis of Unique Speaker and Shouter Counts in Technology Domains"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================

# Plotting
fig, ax = plt.subplots(figsize=(10, 6))

# Error bars and markers
ax.errorbar(
    categories,
    unique_speaker_mean,
    yerr=unique_speaker_error,
    fmt="o",
    color="#1f77b4",  # Deep blue
    marker="s",
    markersize=8,
    label=labels[0],
)
ax.errorbar(
    categories,
    unique_shouter_mean,
    yerr=unique_shouter_error,
    fmt="o",
    color="#ff7f0e",  # Bright orange
    marker="D",
    markersize=8,
    label=labels[1],
)

# Customization
ax.set_ylabel(ylabel)
ax.set_xticklabels(categories, rotation=45, ha="right")
ax.axhline(
    y=sum(unique_shouter_mean) / len(unique_shouter_mean),
    color="grey",
    linestyle="--",
    linewidth=1.5,
    label=axlabel,
)

# Title and Grid
ax.set_title(title)
ax.grid(True, linestyle="--", linewidth=0.5)

# Legend
ax.legend()

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("errorpoint_63.pdf", bbox_inches="tight")
