
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for plotting
categories = [
    "Emails",
    "Phone Calls",
    "Meetings",
    "Instant Messages",
    "Video Conferences",
]
means = [1.5, 2.0, 1.2, 0.8, 1.3]  # Example mean time allocations in hours per day
errors = [0.2, 0.15, 0.1, 0.05, 0.1]  # Example upper error margins in hours
downerrors = [0.1, 0.1, 0.05, 0.03, 0.08]  # Example lower error margins in hours
legendtitles = ["Dataset Mean", "Average Time"]
texttitle = "Average Time Spent per Day"
ylabel = "Time (Hours)"
xlabel = "Communication Methods"
title = "Daily Communication Time Allocation"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
fig, ax = plt.subplots(figsize=(10, 8))

# Adjusting color scheme and marker style
ax.errorbar(
    categories,
    means,
    yerr=[errors, downerrors],
    fmt="s",
    color="#1f77b4",
    ecolor="#1f77b4",
    capsize=5,
    markersize=8,
    markerfacecolor="#ff7f0e",
    markeredgewidth=2,
)

# Adding a legend with both "Average Time" and "Dataset Mean"
dataset_mean = 1.3
mean_line = ax.errorbar(
    [], [], yerr=[], fmt="d", color="#1f77b4", ecolor="#1f77b4", capsize=5, markersize=8,
    markerfacecolor="#ff7f0e", markeredgewidth=2
)
dataset_mean_line = ax.axhline(
    y=dataset_mean, color="#2ca02c", linestyle="--", linewidth=2
)
ax.legend(
    [dataset_mean_line, mean_line],
    legendtitles,
    loc="upper right",
    fancybox=True,
    framealpha=1,
    shadow=True,
    borderpad=1,
)

# Adding a horizontal line for dataset mean and text annotation with a white background
ax.text(
    0.95,
    dataset_mean,
    texttitle,
    va="center",
    ha="right",
    backgroundcolor="white",
    transform=ax.get_yaxis_transform(),
    fontsize=10,
    weight='bold'
)

# Setting labels and title
ax.set_ylabel(ylabel)
ax.set_xlabel(xlabel)
ax.set_title(title)
plt.xticks(rotation=45)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorpoint_67.pdf", bbox_inches="tight")

