
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for plotting
categories = [
    "TECHNOLOGY",
    "HEALTHCARE",
    "FINANCE",
    "ENERGY",
    "RETAIL",
]  # Capitalized category labels
means = [0.05, 0.02, 0.04, 0.03, 0.06]  # Quarterly growth rates
errors = [0.01, 0.008, 0.009, 0.007, 0.011]  # Standard error margins
downerrors = [0.009, 0.007, 0.008, 0.006, 0.01]
legendtitles = ["Quarterly Growth Rate", "Historical Mean"]
texttitle = "Expected Range"
title = "Quarterly Growth Rate of Different Sectors"
ylabel = "Growth Rate (Fraction)"
xlabel = "Sectors"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
fig, ax = plt.subplots(
    figsize=(10, 6)
)  # Adjusting figure size to match new image dimensions
ax.errorbar(
    categories,
    means,
    yerr=[errors, downerrors],
    fmt="o",
    color="gold",
    ecolor="darkorange",
    capsize=5,
    markerfacecolor="lightgoldenrodyellow",
    markeredgewidth=2,
    markeredgecolor="gold",
)

# Adding a legend with both "Mean" and "Historical Mean"
historical_mean = 0.035
mean_line = ax.errorbar(
    [], [], yerr=[], fmt="o", color="gold", ecolor="darkorange", capsize=5
)
historical_mean_line = ax.axhline(
    y=historical_mean, color="navy", linestyle="--", linewidth=1
)
ax.legend(
    [historical_mean_line, mean_line],
    legendtitles,
    loc="upper left",
    fancybox=True,
    framealpha=1,
    shadow=True,
    borderpad=1,
)
# Adding a horizontal line for dataset mean and text annotation with a white background
ax.text(
    0.95,
    historical_mean,
    texttitle,
    va="center",
    ha="right",
    backgroundcolor="white",
    transform=ax.get_yaxis_transform(),
)

# Setting labels and a title
ax.set_ylabel(ylabel)
ax.set_xlabel(xlabel)
ax.set_title(title)
plt.xticks(rotation=30)
plt.grid(True, which="both", axis="y", linestyle="--", linewidth=0.5)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorpoint_69.pdf", bbox_inches="tight")
