
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# example weather data
x = np.arange(1, 13, 1)  # representing months
y = [3.0, 4.5, 9.6, 14.2, 18.7, 22.5, 24.0, 23.6, 19.1, 13.5, 8.1, 4.2]  # average temperature in Celsius
error = np.array([1.0, 1.2, 1.3, 1.5, 1.4, 1.6, 1.5, 1.4, 1.3, 1.2, 1.1, 1.0])  # symmetric error
lower_error = 0.6 * error  # Adjusted asymmetric error
upper_error = error
asymmetric_error = [lower_error, upper_error]

suptitle = "Average Monthly Temperature with Error Margins"
title1 = "Symmetric Error Margins"
title2 = "Asymmetric Error Margins"
xlabel = "Time (Months)"
ylabel = "Average Temperature (°C)"
legend_label = "Temperature Data"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, (ax0, ax1) = plt.subplots(figsize=(14, 6), ncols=2, sharex=True)
fig.suptitle(suptitle, fontsize=16)

# Plot with symmetric error
ax0.errorbar(
    x,
    y,
    yerr=error,
    fmt="o",
    color="dodgerblue",
    ecolor="deepskyblue",
    elinewidth=2,
    capsize=5,
    label=legend_label,
)
ax0.set_title(title1, fontsize=14)
ax0.set_xlabel(xlabel, fontsize=12)
ax0.set_ylabel(ylabel, fontsize=12)
ax0.legend()
ax0.grid(True)

# Plot with asymmetric error
ax1.errorbar(
    x,
    y,
    yerr=asymmetric_error,
    fmt="^",
    color="darkorange",
    ecolor="orangered",
    elinewidth=2,
    capsize=5,
    label=legend_label,
)
ax1.set_title(title2, fontsize=14)
ax1.set_xlabel(xlabel, fontsize=12)
ax1.set_yscale("log")
ax1.legend()
ax1.grid(True)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout(rect=[0, 0.03, 1, 0.95])
plt.savefig("errorpoint_72.pdf", bbox_inches="tight")
