
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# example tourism data
x = np.arange(1, 13, 1)
y = [
    1200, 1500, 1300, 900, 800, 1100, 1400, 1700, 1600, 1300, 900, 1000
]  # average monthly tourist arrivals (in thousands)
error = np.array([100, 120, 90, 110, 80, 100, 130, 140, 150, 90, 80, 70])  # symmetric error
lower_error = 0.7 * error  # Adjusted asymmetric error
upper_error = error
asymmetric_error = [lower_error, upper_error]

title1 = "Monthly Tourist Arrivals with Symmetric Error Margins"
title2 = "Monthly Tourist Arrivals with Asymmetric Error Margins"
xlabel = "Time (Months)"
ylabel = "Tourist Arrivals (in thousands)"
legend_label = "Tourist Data"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, (ax0, ax1) = plt.subplots(figsize=(12, 6), ncols=2, sharex=True)

# Plot with symmetric error
ax0.errorbar(
    x,
    y,
    yerr=error,
    fmt="o",
    color="mediumseagreen",
    ecolor="lightgray",
    elinewidth=2,
    capsize=5,
    label=legend_label,
)
ax0.set_title(title1, fontsize=14)
ax0.set_xlabel(xlabel, fontsize=12)
ax0.set_ylabel(ylabel, fontsize=12)
ax0.legend()

# Plot with asymmetric error
ax1.errorbar(
    x,
    y,
    yerr=asymmetric_error,
    fmt="v",
    color="royalblue",
    ecolor="darkorange",
    elinewidth=2,
    capsize=5,
    label=legend_label,
)
ax1.set_title(title2, fontsize=14)
ax1.set_xlabel(xlabel, fontsize=12)
ax1.set_ylabel(ylabel, fontsize=12)
ax1.legend()

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorpoint_74.pdf", bbox_inches="tight")
