
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
months = [
    "Jan",
    "Feb",
    "Mar",
    "Apr",
    "May",
    "Jun",
    "Jul",
    "Aug",
    "Sep",
    "Oct",
    "Nov",
    "Dec",
]

x = np.arange(len(months))  # Months
temp_city_a = np.random.uniform(0, 10, len(months))
temp_city_b = np.random.uniform(5, 20, len(months))
temp_city_c = np.random.uniform(-5, 15, len(months))
error_city_a = [
    np.random.uniform(0.5, 2.0, len(months)),
    np.random.uniform(0.5, 2.0, len(months)),
]
error_city_b = [
    np.random.uniform(0.5, 2.0, len(months)),
    np.random.uniform(0.5, 2.0, len(months)),
]  # Symmetric horizontal error
error_city_c = np.random.uniform(0.5, 2.0, len(months))
chart_title = "Monthly Average Temperatures of Cities with Error Bars"
highlight_month = 6  # July

ylabel = [
    "City A Temp (°C)",
    "City B Temp (°C)",
    "City C Temp (°C)",
]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with three subplots and shared x-axis
fig, (ax0, ax1, ax2) = plt.subplots(figsize=(8, 12), nrows=3, sharex=True)
colors_city_a = plt.get_cmap("Blues")(np.linspace(0.5, 1.0, len(months)))
colors_city_b = plt.get_cmap("Oranges")(np.linspace(0.5, 1.0, len(months)))
color_city_c = "darkgreen"

# First subplot with symmetric vertical error bars (City A temperatures)
for i in range(len(x)):
    ax0.errorbar(
        x[i],
        temp_city_a[i],
        yerr=[[error_city_a[0][i]], [error_city_a[1][i]]],
        fmt="o",
        color=colors_city_a[i],
        capsize=4,
    )
    ax0.text(
        x[i] - 0.2,
        temp_city_a[i] + 0.1,
        f"{temp_city_a[i]:.2f}",
        fontsize=8,
        ha="right",
    )
ax0.set_title(chart_title)
ax0.axhline(y=5, linestyle="--", color="#6b8e23")
ax0.set_ylabel(ylabel[0])
ax0.yaxis.grid(True)
ax0.xaxis.grid(False)

# Second subplot with symmetric horizontal error bars (City B temperatures)
for i in range(len(x)):
    ax1.errorbar(
        x[i],
        temp_city_b[i],
        xerr=[[error_city_b[0][i]], [error_city_b[1][i]]],
        fmt="o",
        color=colors_city_b[i],
        markersize=8,
    )
    ax1.text(
        x[i] + 0.1,
        temp_city_b[i] + 0.2,
        f"{temp_city_b[i]:.2f}",
        fontsize=8,
        ha="left",
    )
ax1.axvline(x=highlight_month, linestyle="--", color="#d45500")
ax1.set_ylabel(ylabel[1])
ax1.yaxis.grid(True)
ax1.xaxis.grid(False)

# Third subplot with symmetric vertical error bars (City C temperatures)
ax2.errorbar(
    x, temp_city_c, yerr=error_city_c, fmt="*", color=color_city_c, capsize=2
)
for i in range(len(x)):
    ax2.text(
        x[i],
        temp_city_c[i] + 0.2,
        f"{temp_city_c[i]:.2f}",
        fontsize=8,
        ha="center",
    )
ax2.set_ylabel(ylabel[2])
ax2.yaxis.grid(True)
ax2.xaxis.grid(False)

# Set shared x-axis labels
plt.xticks(x, months)
ax2.set_xlabel("Month")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and display the plot
plt.tight_layout()
plt.savefig("errorpoint_79.pdf", bbox_inches="tight")
