
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import networkx as nx
import numpy as np

# Labels and Title
title = "Social Network Analysis in Psychology"
legend_labels = ["Connections", "Strong Connections"]

np.random.seed(0)
# Create a random graph
G = nx.random_geometric_graph(30, 0.3)

# Position the nodes based on their connections using a different layout algorithm
pos = nx.kamada_kawai_layout(
    G
)  # This layout algorithm may produce a more spread-out layout

# Randomly select some edges to color differently
edges = list(G.edges())
highlighted_edges = np.random.choice(
    len(edges), size=int(len(edges) * 0.3), replace=False
)  # 30% of the edges
highlighted_edges = [edges[i] for i in highlighted_edges]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(8, 8))

# Draw the nodes
nx.draw_networkx_nodes(G, pos, node_size=200, node_color="#87CEEB")  # Sky blue nodes

# Draw the edges with transparency
nx.draw_networkx_edges(G, pos, alpha=0.3, edge_color="#C0C0C0")  # Light grey edges

# Draw the highlighted edges in a different color
nx.draw_networkx_edges(G, pos, edgelist=highlighted_edges, edge_color="#4682B4", width=2)  # Steel blue edges

# Remove axis
plt.axis("off")

# Add a legend
blue_patch = plt.Line2D([0], [0], color='#C0C0C0', lw=2, label=legend_labels[0])
highlight_patch = plt.Line2D([0], [0], color='#4682B4', lw=2, label=legend_labels[1])
plt.legend(handles=[blue_patch, highlight_patch], loc='upper right')

# Add a title
plt.title(title, fontsize=15)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("graph_25.pdf", bbox_inches="tight")
