
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import networkx as nx

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Create a random graph representing a media network
G = nx.gnm_random_graph(12, 18)
weights = {edge: np.random.randint(1, 10) for edge in G.edges()}
nx.set_edge_attributes(G, weights, "weight")

# Layout for visualization
pos = nx.spring_layout(G, iterations=200)

# Node labels
labels = {i: f"User {i}" for i in range(12)}

# Draw edge labels
edge_labels = {edge: f"{weight}" for edge, weight in nx.get_edge_attributes(G, "weight").items()}

# Graph title and labels
title = "Social Media Interaction Network"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(12, 10))
nx.draw(
    G, pos, 
    node_size=1000, 
    node_color="skyblue", 
    edge_color="orange", 
    style="dashed", 
    width=2,
)
nx.draw_networkx_labels(G, pos, labels=labels, font_size=12, font_color="black")
nx.draw_networkx_edge_labels(G, pos, edge_labels=edge_labels, font_size=12, font_color="green", font_weight="bold")

# Add title
plt.title(title, size=20)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot
plt.tight_layout()
plt.savefig("graph_28.pdf", bbox_inches="tight")
