
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import networkx as nx

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Create a cycle graph representing character interactions in a TV series
G = nx.cycle_graph(12)
weights = {edge: np.random.randint(1, 10) for edge in G.edges()} # Random weights as interactions count
nx.set_edge_attributes(G, weights, "weight")

pos = nx.spring_layout(G, iterations=200)
labels = {i: f"Character {i}" for i in range(12)}
edge_labels = nx.get_edge_attributes(G, "weight")

# Labels for the chart
chart_title = "Character Interactions in TV Series"
xlabel = "Interaction Count"
ylabel = "Characters"
legend_labels = ["Low Interaction", "High Interaction"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(14, 10))

# Draw the graph with custom styling
node_color = plt.cm.plasma(np.linspace(0, 1, 12))
edge_colors = [plt.cm.viridis(weight / 10) for weight in weights.values()]
nx.draw(G, pos, node_size=1000, node_color=node_color, edge_color=edge_colors, width=2, with_labels=False)
nx.draw_networkx_labels(G, pos, labels=labels, font_size=12, font_color="white")
nx.draw_networkx_edge_labels(G, pos, edge_labels=edge_labels, font_color="red", font_size=8)

# Adding title and labels
plt.title(chart_title, fontsize=16, fontweight="bold", color="navy")
plt.xlabel(xlabel, fontsize=12, color="darkslategray")
plt.ylabel(ylabel, fontsize=12, color="darkslategray")
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Show the plot
plt.tight_layout()
plt.savefig("graph_29.pdf", bbox_inches="tight")
