
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import networkx as nx

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
G = nx.house_graph()
# updated positions for aesthetic layout
pos = {0: (0, 0), 1: (1, 0), 2: (0, 1), 3: (1, 1), 4: (0.5, 2.5)}

# Labels
labels = {0: "Living Room", 1: "Kitchen", 2: "Bedroom", 3: "Bathroom", 4: "Roof"}
title = "Artistic House Graph Layout"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(10, 8), facecolor='#f0f0f5')  # Light grey background

# Drawing nodes with different colors and markers
nx.draw_networkx_nodes(G, pos, node_size=2000, nodelist=[4], node_color="#8dd3c7", node_shape='^')
nx.draw_networkx_nodes(
    G, pos, node_size=3000, nodelist=[0, 1, 2, 3], node_color="#bebada", node_shape='o'
)

# Drawing edges with different transparency and width
nx.draw_networkx_edges(G, pos, alpha=0.7, width=4, edge_color="#fb8072")

# Adding text annotations with custom font size and style
nx.draw_networkx_labels(G, pos, labels=labels, font_size=14, font_family='sans-serif', font_color="#383e56")
plt.title(title, fontsize=18, fontweight='bold', fontfamily='serif', color="#383e56")

plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("graph_32.pdf", bbox_inches="tight")
