
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import networkx as nx
import numpy as np

# Create a graph and add a self-loop to node 0
G = nx.complete_graph(3, create_using=nx.DiGraph)
# G.add_edge(0, 0)
pos = nx.circular_layout(G)

# Add self-loops to the remaining nodes
edgelist = [(1, 1), (2, 2), (0, 0)]
G.add_edges_from(edgelist)

# Labels for nodes
labels = {
    0: 'TV Station',
    1: 'Newspaper',
    2: 'Online Platform'
}

# Titles and labels
title = "Interconnections in Media"
xlabel = ""
ylabel = ""
legend_label = 'Self-Loops'

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(12, 10))

# Draw main graph with enhanced styling
nx.draw(
    G, pos, with_labels=True, labels=labels, node_color='#66c2a5',
    node_size=3000, font_size=12, font_color='black', 
    edge_color='#8da0cb', width=2.0
)

# Draw self-loops with distinct formatting
nx.draw_networkx_edges(
    G, pos, edgelist=edgelist, arrowstyle="<|-", style="dotted",
    edge_color='red', width=2.5
)

# Adding legend for self-loops
handles = [plt.Line2D([0], [0], color='red', linestyle='dotted', lw=2.5)]
labels = [legend_label]
plt.legend(handles, labels, loc='upper right')

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.title(title, fontsize=16)
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.tight_layout()
plt.savefig("graph_34.pdf", bbox_inches="tight")
