
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import networkx as nx

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Create a new graph representing an art exhibition network
G = nx.Graph()

# Add nodes representing different art-related entities
nodes = [
    ("Museum of Modern Art", {"type": "Museum"}),
    ("Gallery A", {"type": "Gallery"}),
    ("Gallery B", {"type": "Gallery"}),
    ("Artist X", {"type": "Artist"}),
    ("Artist Y", {"type": "Artist"}),
    ("Curator Z", {"type": "Curator"}),
]
G.add_nodes_from(nodes)

# Add edges representing collaborations or interactions
edges = [
    ("Museum of Modern Art", "Gallery A"),
    ("Museum of Modern Art", "Gallery B"),
    ("Gallery A", "Artist X"),
    ("Gallery B", "Artist Y"),
    ("Artist X", "Curator Z"),
    ("Artist Y", "Curator Z"),
    ("Curator Z", "Museum of Modern Art"),
]
G.add_edges_from(edges)

# Define positions for nodes explicitly
pos = {
    "Museum of Modern Art": (1, 2),
    "Gallery A": (0.5, 1.5),
    "Gallery B": (1.5, 1.5),
    "Artist X": (0.5, 1),
    "Artist Y": (1.5, 1),
    "Curator Z": (1, 0.5),
}
title = "Art Exhibition Network"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(12, 10))

# Node color mapping based on entity type
color_map = {
    "Museum": "#FF6B6B",
    "Gallery": "#6BFFB3",
    "Artist": "#6B83FF",
    "Curator": "#FFD36B",
}

# Draw nodes with colors based on their type
node_colors = [color_map[G.nodes[node]["type"]] for node in G.nodes]
nx.draw_networkx_nodes(
    G, pos, node_color=node_colors, node_size=4000, edgecolors="black"
)

# Draw edges with customized style
nx.draw_networkx_edges(
    G, pos, edge_color="gray", alpha=0.8, width=2.5, style="dashed"
)

# Add labels to nodes
labels = {node: node for node in G.nodes}
nx.draw_networkx_labels(G, pos, labels=labels, font_size=14, font_color="black", font_family="sans-serif", font_weight="bold")

# Create legend for node colors
import matplotlib.patches as mpatches

legend_elements = [
    mpatches.Patch(color=color, label=label) for label, color in color_map.items()
]
plt.legend(handles=legend_elements, loc="upper left", frameon=False, fontsize=12)

# Title and axis settings
plt.title(title, fontsize=20, fontweight="bold", fontname="sans-serif")
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("graph_51.pdf", bbox_inches="tight")
