
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import networkx as nx

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Create a new graph representing a cloud computing architecture
G = nx.Graph()

# Add nodes representing different components in a cloud computing system
nodes = [
    ("Servers", {"type": "Infrastructure"}),
    ("Storage", {"type": "Infrastructure"}),
    ("Network", {"type": "Infrastructure"}),
    ("Service Provider", {"type": "Service Provider"}),
    ("Business User", {"type": "User"}),
    ("Home User", {"type": "User"}),
    ("Regulator", {"type": "Government"}),
]
G.add_nodes_from(nodes)

# Add edges representing interactions
edges = [
    ("Servers", "Service Provider"),
    ("Storage", "Service Provider"),
    ("Network", "Service Provider"),
    ("Service Provider", "Business User"),
    ("Service Provider", "Home User"),
    ("Service Provider", "Regulator"),
    ("Network", "Regulator"),
]
G.add_edges_from(edges)

# Define positions for nodes explicitly
pos = {
    "Servers": (1, 2),
    "Storage": (2, 2),
    "Network": (0, 2),
    "Service Provider": (1.5, 1),
    "Business User": (0.5, 0),
    "Home User": (2.5, 0),
    "Regulator": (1.5, 3),
}
title = "Cloud Computing Architecture"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(12, 10))

# Node color mapping based on entity type
color_map = {
    "Infrastructure": "lightcoral",
    "Service Provider": "lightskyblue",
    "User": "lightgreen",
    "Government": "lightgoldenrodyellow",
}
# Draw nodes with colors based on their type
node_colors = [color_map[G.nodes[node]["type"]] for node in G.nodes]
nx.draw_networkx_nodes(
    G, pos, node_color=node_colors, node_size=4000, edgecolors="black"
)

# Draw edges with alpha for transparency and consistent width
nx.draw_networkx_edges(G, pos, edge_color="gray", alpha=0.7, width=2.5)

# Add labels to nodes
labels = {node: node for node in G.nodes}
nx.draw_networkx_labels(G, pos, labels=labels, font_size=14, font_color="black")

# Create legend for node colors
import matplotlib.patches as mpatches

legend_elements = [
    mpatches.Patch(color=color, label=label) for label, color in color_map.items()
]
plt.legend(handles=legend_elements, loc="upper left", frameon=False, fontsize=12)

# Title and axis settings
plt.title(title, fontsize=20, fontweight="bold")
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("graph_52.pdf", bbox_inches="tight")
