
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import networkx as nx

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Create a new graph representing a hypothetical art and design network
G = nx.Graph()

# Add nodes representing different entities in the art and design world
nodes = [
    ("Artist", {"type": "Creator"}),
    ("Art Dealer", {"type": "Mediator"}),
    ("Gallery", {"type": "Exhibitor"}),
    ("Collector", {"type": "Buyer"}),
    ("Museum", {"type": "Institution"}),
]
G.add_nodes_from(nodes)

# Add edges representing interactions
edges = [
    ("Artist", "Art Dealer"),
    ("Artist", "Gallery"),
    ("Art Dealer", "Gallery"),
    ("Gallery", "Collector"),
    ("Collector", "Museum"),
    ("Museum", "Artist"),
    ("Art Dealer", "Collector"),
]
G.add_edges_from(edges)

# Define positions for nodes explicitly
pos = {
    "Artist": (1, 1),
    "Art Dealer": (2, 2),
    "Gallery": (1, 2),
    "Collector": (0, 1),
    "Museum": (0.5, 3),
}
title = "Art and Design Network"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(12, 10))

# Node color mapping based on entity type
color_map = {
    "Creator": "coral",
    "Mediator": "turquoise",
    "Exhibitor": "lightgreen",
    "Buyer": "violet",
    "Institution": "lightblue",
}
# Draw nodes with colors based on their type
node_colors = [color_map[G.nodes[node]["type"]] for node in G.nodes]
nx.draw_networkx_nodes(
    G, pos, node_color=node_colors, node_size=4000, edgecolors="black"
)

# Draw edges with alpha for transparency and consistent width
nx.draw_networkx_edges(G, pos, edge_color="gray", alpha=0.7, width=2.5)

# Add labels to nodes
labels = {node: node for node in G.nodes}
nx.draw_networkx_labels(G, pos, labels=labels, font_size=14, font_color="black")

# Create legend for node colors
import matplotlib.patches as mpatches

legend_elements = [
    mpatches.Patch(color=color, label=label) for label, color in color_map.items()
]
plt.legend(handles=legend_elements, loc="upper left", frameon=False, fontsize=12)

# Title and axis settings
plt.title(title, fontsize=20, fontweight="bold")
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("graph_53.pdf", bbox_inches="tight")
