
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import networkx as nx
import numpy as np

# Create a directed graph representing tech company communication network
G = nx.DiGraph()

# Add nodes representing departments
G.add_nodes_from(["HR", "Engineering", "Sales", "Marketing", "Support"])

# Add edges representing communication channels between departments
communication_edges = [("HR", "Engineering"), ("HR", "Sales"), ("Engineering", "Marketing"), ("Sales", "Support"), ("Support", "Marketing")]

# Add self-loops representing personal tasks within each department
self_loops = [("HR", "HR"), ("Engineering", "Engineering"), ("Sales", "Sales"), ("Marketing", "Marketing"), ("Support", "Support")]

# Combine all edges
G.add_edges_from(communication_edges + self_loops)

# Position nodes using a circular layout
pos = nx.circular_layout(G)

# Text labels and other plot annotations
title = "Tech Company Communication Network"
xlabel = ""
ylabel = ""
annotation_text = "Solid Lines: Department Interaction\nDashed Lines: Departmental Tasks"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(10, 8))

# Draw the graph with custom node and edge colors
nx.draw(G, pos, with_labels=True, node_color="deepskyblue", edge_color="lightgray", node_size=3000, font_size=12, font_color="black")

# Highlight the communication edges with bold solid lines
nx.draw_networkx_edges(
    G,
    pos,
    edgelist=communication_edges,
    edge_color="blue",
    style="solid",
    width=2,
    arrowstyle="->",
    arrowsize=20
)

# Highlight the self-loops with bold dashed lines and different arrow style
nx.draw_networkx_edges(
    G, pos, edgelist=self_loops, edge_color="green", style="dashed", width=2, arrowstyle="<|-|>", arrowsize=20
)

# Add a title and legend to the plot
plt.title(title, fontsize=16)
props = dict(boxstyle="round", facecolor="lavender", alpha=0.5)
plt.text(
    0.05,
    0.95,
    annotation_text,
    transform=plt.gca().transAxes,
    fontsize=12,
    verticalalignment="top",
    bbox=props,
)

plt.xlabel(xlabel)
plt.ylabel(ylabel)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("graph_55.pdf", bbox_inches="tight")
