
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import networkx as nx
import numpy as np

# Create a directed graph
G = nx.DiGraph()

# Add nodes representing different entities in society
nodes = [
    "Government Body",
    "Educational Institution",
    "Healthcare Facility",
    "Citizen A",
    "Citizen B",
]
for node in nodes:
    G.add_node(node)

# Define edges representing the interactions between entities
edges = [
    ("Government Body", "Educational Institution"),
    ("Government Body", "Healthcare Facility"),
    ("Educational Institution", "Citizen A"),
    ("Healthcare Facility", "Citizen B"),
    (
        "Educational Institution",
        "Educational Institution",
    ),  # Self-loop for internal processes in education
    (
        "Healthcare Facility",
        "Healthcare Facility",
    ),  # Self-loop for internal processes in healthcare
    (
        "Government Body",
        "Government Body",
    ),  # Self-loop for internal processes in government
]

# Add edges to the graph
G.add_edges_from(edges)

# Define positions for a clear layout
pos = nx.spring_layout(G, seed=42)

# Titles and Labels
title = "Inter-Entity Interaction in Society"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(12, 10))

# Draw the graph with customized node colors and labels
node_colors = [
    "red" if "Government Body" in node else
    "blue" if "Educational Institution" in node else
    "green" if "Healthcare Facility" in node else
    "yellow" for node in G.nodes()
]

# Draw nodes and edges
nx.draw(
    G,
    pos,
    with_labels=True,
    node_color=node_colors,
    node_size=3000,
    font_size=10,
    font_weight="bold",
    edge_color="gray",
)

# Draw edges with differentiated styles for self-loops
self_loops = [(u, v) for u, v in G.edges() if u == v]
other_edges = [(u, v) for u, v in G.edges() if u != v]

nx.draw_networkx_edges(
    G,
    pos,
    edgelist=other_edges,
    arrowstyle="-|>",
    arrowsize=20,
    width=2.0,
    edge_color="black",
)
nx.draw_networkx_edges(
    G,
    pos,
    edgelist=self_loops,
    arrowstyle="-|>",
    style="dashed",
    arrowsize=20,
    width=2.0,
    edge_color="orange",
)

# Title and labels
plt.title(title, fontsize=15)
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("graph_60.pdf", bbox_inches="tight")
