
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import networkx as nx

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Create a directed graph
G = nx.DiGraph()

# Add nodes representing different entities in the energy flow
nodes = [
    "Power Plant",
    "Substation A",
    "Substation B",
    "Residential Area 1",
    "Residential Area 2",
    "Commercial Area",
]
for node in nodes:
    G.add_node(node)

# Define edges representing energy flow between entities
edges = [
    ("Power Plant", "Substation A"),
    ("Power Plant", "Substation B"),
    ("Substation A", "Residential Area 1"),
    ("Substation A", "Commercial Area"),
    ("Substation B", "Residential Area 2"),
    ("Substation B", "Commercial Area"),
    ("Substation A", "Substation A"),  # Self-loop for energy storage or processing
    ("Substation B", "Substation B"),  # Self-loop for energy storage or processing
]

# Add edges to the graph
G.add_edges_from(edges)

# Define positions for a clear layout
pos = nx.spring_layout(G, seed=42)

# Define titles and labels
title = "Energy Distribution Flow Between Entities"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(12, 10))

# Define node colors based on different entities
node_colors = [
    "green" if "Power Plant" in node else
    "blue" if "Substation" in node else
    "orange" if "Residential Area" in node else
    "purple" for node in G.nodes()
]

# Draw the graph with the customized node colors and labels
nx.draw(
    G,
    pos,
    with_labels=True,
    node_color=node_colors,
    node_size=3000,
    font_size=12,
    font_weight="bold",
    edge_color="gray",
)

# Draw edges with differentiated styles for self-loops
self_loops = [(u, v) for u, v in G.edges() if u == v]
other_edges = [(u, v) for u, v in G.edges() if u != v]

nx.draw_networkx_edges(
    G,
    pos,
    edgelist=other_edges,
    arrowstyle="-|>",
    arrowsize=20,
    width=2.5,
    edge_color="black",
)
nx.draw_networkx_edges(
    G,
    pos,
    edgelist=self_loops,
    arrowstyle="-|>",
    style="dashed",
    arrowsize=20,
    width=2.5,
    edge_color="red",
)

# Title and labels
plt.title(title, fontsize=20)
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("graph_61.pdf", bbox_inches="tight")
