
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import networkx as nx

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Creating a graph structure for an educational layout
G = nx.cubical_graph()
# explicitly set positions (e.g., rooms in a school layout)
pos = {
    0: (0, 0), 1: (2, 0), 2: (0, 2), 3: (2, 2),
    4: (1, 1), 5: (3, 1), 6: (1, 3), 7: (3, 3)
}
labels = {
    0: "Main Administrative Office",
    1: "Classroom (Math)",
    2: "Classroom (Science)",
    3: "Computer Lab",
    4: "Library",
    5: "Art Room",
    6: "Physics Lab",
    7: "Chemistry Lab",
}

# Set the plot title and subtitle
title = "School Layout and Connectivity"
suptitle = "Network of Classrooms and Administrative Office"
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(14, 12))

# Nodes configuration
nx.draw_networkx_nodes(
    G,
    pos,
    node_size=400,
    nodelist=[0],
    node_color="skyblue",
    edgecolors="black",
    linewidths=3,
)
nx.draw_networkx_nodes(
    G,
    pos,
    node_size=350,
    nodelist=[1, 2, 3, 4, 5, 6, 7],
    node_color="lightgreen",
    edgecolors="black",
    linewidths=2,
)

# Edges configuration
nx.draw_networkx_edges(G, pos, alpha=0.7, width=3, edge_color="mediumaquamarine")

# Adding text annotations - Labels for rooms
nx.draw_networkx_labels(
    G, pos, labels=labels, font_size=14, font_color="black", font_family="sans-serif"
)

# Title and axis configurations
plt.title(title, fontsize=26, fontweight="bold")
plt.suptitle(suptitle, fontsize=18, style="italic")
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("graph_75.pdf", bbox_inches="tight")
