
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import networkx as nx

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Creating a directed graph to represent a supply chain network
G = nx.DiGraph()

# Adding nodes with categories: 0 - Suppliers, 1 - Factories, 2 - Warehouses, 3 - Retailers
nodes = {
    0: "Supplier (China)",
    1: "Supplier (Germany)",
    2: "Factory (USA)",
    3: "Factory (Mexico)",
    4: "Warehouse (Canada)",
    5: "Warehouse (Brazil)",
    6: "Retailer (UK)",
    7: "Retailer (Australia)"
}

# Adding edges to represent the flow of goods
edges = [
    (0, 2), (0, 3),
    (1, 2), (1, 3),
    (2, 4), (2, 5),
    (3, 4), (3, 5),
    (4, 6), (5, 7)
]

# Adding nodes and edges to the graph
G.add_nodes_from(nodes.keys())
G.add_edges_from(edges)

# Positioning the nodes manually for clarity
pos = {
    0: (0, 2), 1: (6, 2),
    2: (2, 1), 3: (4, 1),
    4: (2, 0), 5: (4, 0),
    6: (1, -1), 7: (5, -1)
}

# Labels for nodes
labels = nodes

# Set the plot title and subtitle
title = "Supply Chain Network"
suptitle = "Flow of Goods from Suppliers to Retailers"

nx.set_node_attributes(G, labels, 'label')

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(14, 10))

# Nodes configuration
nx.draw_networkx_nodes(
    G,
    pos,
    nodelist=[0, 1],
    node_color="lightblue",
    node_size=500,
    edgecolors="black",
    linewidths=2,
    label="Suppliers",
)
nx.draw_networkx_nodes(
    G,
    pos,
    nodelist=[2, 3],
    node_color="lightgreen",
    node_size=500,
    edgecolors="black",
    linewidths=2,
    label="Factories",
)
nx.draw_networkx_nodes(
    G,
    pos,
    nodelist=[4, 5],
    node_color="orange",
    node_size=500,
    edgecolors="black",
    linewidths=2,
    label="Warehouses",
)
nx.draw_networkx_nodes(
    G,
    pos,
    nodelist=[6, 7],
    node_color="salmon",
    node_size=500,
    edgecolors="black",
    linewidths=2,
    label="Retailers",
)

# Edges configuration
nx.draw_networkx_edges(
    G,
    pos,
    edgelist=edges,
    arrowstyle='-|>',
    arrowsize=20,
    edge_color="gray",
    width=2,
    connectionstyle="arc3,rad=0.1"
)

# Adding text annotations
nx.draw_networkx_labels(
    G, pos, labels=labels, font_size=12, font_color="black", font_family="sans-serif"
)

# Title and axis configurations
plt.title(title, fontsize=24, fontweight="bold")
plt.suptitle(suptitle, fontsize=16, style="italic")
plt.axis("off")
plt.legend(scatterpoints=1, loc='best', fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("graph_77.pdf", bbox_inches="tight")
