
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import networkx as nx
import numpy as np
import random

# Historical event nodes and connections
random.seed(20)
np.random.seed(42)

# Creating a random historical graph with 12 events
G = nx.erdos_renyi_graph(12, 0.3)
weights = {edge: np.random.randint(1, 10) for edge in G.edges()}
nx.set_edge_attributes(G, weights, "weight")

# Use a spring layout for node positions
pos = nx.spring_layout(G, seed=42)

# Labels for historical events
labels = {
    0: "Event 0", 1: "Event 1", 2: "Event 2", 3: "Event 3",
    4: "Event 4", 5: "Event 5", 6: "Event 6", 7: "Event 7",
    8: "Event 8", 9: "Event 9", 10: "Event 10", 11: "Event 11"
}

# Draw edge labels
edge_labels = nx.get_edge_attributes(G, "weight")

# Chart title
title = "Historical Events Network"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(14, 10))

# Draw nodes with historical color theme
nx.draw(
    G, pos, node_size=800, node_color="tan", edge_color="gray", with_labels=False
)

# Draw the labels for the events (nodes)
nx.draw_networkx_labels(
    G, pos, labels=labels, font_color="black", font_size=12, font_weight="bold"
)

# Draw the edges with varying widths based on historical significance (weights)
nx.draw_networkx_edges(
    G, pos, width=[weights[edge] * 0.5 for edge in G.edges()], style="dashed", edge_color="darkgoldenrod"
)

# Draw edge labels with connection importance
nx.draw_networkx_edge_labels(
    G, pos, edge_labels=edge_labels, font_color="brown", font_size=10
)

# Add a title and configure layout
plt.title(title, size=20, fontweight='bold')
plt.tight_layout()

# ===================
# Part 4: Saving Output
# ===================
# Save the plot
plt.savefig("graph_79.pdf", bbox_inches="tight")
