
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# New data
cities = ["City A", "City B", "City C", "City D", "City E", "City F", "City G"]
months = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]

# Simulating average monthly temperatures (°C)
temperatures = np.array(
    [
        [5, 7, 9, 15, 20, 25, 30, 29, 24, 18, 10, 6],
        [4, 6, 10, 16, 21, 26, 31, 28, 23, 17, 9, 5],
        [3, 5, 8, 14, 19, 24, 29, 27, 22, 16, 8, 4],
        [2, 4, 7, 13, 18, 23, 28, 26, 21, 15, 7, 3],
        [1, 3, 6, 12, 17, 22, 27, 25, 20, 14, 6, 2],
        [0, 2, 5, 11, 16, 21, 26, 24, 19, 13, 5, 1],
        [-1, 1, 4, 10, 15, 20, 25, 23, 18, 12, 4, 0],
    ]
)

title = "Average Monthly Temperatures (°C) in Various Cities"
xlabel = "Months"
ylabel = "Cities"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(10, 7))

im = ax.imshow(temperatures, cmap="coolwarm")

# Show all ticks and label them with the respective list entries
ax.set_xticks(np.arange(len(months)), labels=months)
ax.set_yticks(np.arange(len(cities)), labels=cities)

# Rotate the tick labels and set their alignment
plt.setp(ax.get_xticklabels(), rotation=45, ha="right", rotation_mode="anchor")

# Loop over data dimensions and create text annotations
for i in range(len(cities)):
    for j in range(len(months)):
        text = ax.text(j, i, temperatures[i, j], ha="center", va="center", color="black")

ax.set_title(title)
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)

# Add a colorbar
cbar = ax.figure.colorbar(im, ax=ax)
cbar.ax.set_ylabel("Temperature (°C)", rotation=-90, va="bottom")

# ===================
# Part 4: Saving Output
# ===================
fig.tight_layout()
plt.savefig("heatmap_112.pdf", bbox_inches="tight")
