
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# New data for science domain
compounds = ["Compound A", "Compound B", "Compound C", "Compound D", "Compound E", "Compound F", "Compound G"]
soil_samples = [
    "Sample 1",
    "Sample 2",
    "Sample 3",
    "Sample 4",
    "Sample 5",
    "Sample 6",
    "Sample 7",
]

# Concentration data in mg/kg
concentration = np.array(
    [
        [15, 22, 18, 32, 5, 38, 3],
        [28, 5, 36, 18, 22, 7, 6],
        [10, 21, 9, 40, 15, 42, 4],
        [7, 6, 4, 5, 34, 5, 6],
        [9, 16, 7, 23, 20, 59, 5],
        [12, 13, 5, 6, 7, 31, 48],
        [3, 19, 6, 13, 8, 18, 59],
    ]
)

title = "Concentration of Various Compounds in Soil Samples (mg/kg)"
xlabel = "Soil Samples"
ylabel = "Compounds"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(10, 8))

im = ax.imshow(concentration, cmap="viridis")

# Show all ticks and label them with the respective list entries
ax.set_xticks(np.arange(len(soil_samples)), labels=soil_samples)
ax.set_yticks(np.arange(len(compounds)), labels=compounds)

# Rotate the tick labels and set their alignment.
plt.setp(ax.get_xticklabels(), rotation=45, ha="right", rotation_mode="anchor")

# Loop over data dimensions and create text annotations.
for i in range(len(compounds)):
    for j in range(len(soil_samples)):
        text = ax.text(j, i, concentration[i, j], ha="center", va="center", color="white")

ax.set_title(title)
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)

# ===================
# Part 4: Saving Output
# ===================
fig.tight_layout()
plt.savefig("heatmap_113.pdf", bbox_inches="tight")
