
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.colors as colors

# ===================
# Part 2: Data Preparation
# ===================
# Data
data = [
    [70, 65, 55, 40],
    [30, 45, 60, 75],
    [50, 60, 70, 65],
    [40, 55, 45, 35]
]
yticklabels = ["Teenagers", "Young Adults", "Adults", "Seniors"]
title = "Popularity of Art Styles Across Age Groups"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Color scheme related to art and design
colors_list = ["#ff9999", "#66b3ff", "#99ff99", "#ffcc99"]
cmap = colors.ListedColormap(colors_list)
plt.figure(figsize=(7, 6))
# Plot the heatmap with custom colors and annotations
plt.imshow(data, cmap=cmap, vmin=0, vmax=100, extent=[0, 4, 0, 4])
for i in range(4):
    for j in range(4):
        plt.annotate(
            str(data[i][j]),
            xy=(j + 0.5, i + 0.5),
            ha="center",
            va="center",
            color="black",
            fontsize=12,
            fontweight='bold'
        )

# Add colorbar
cbar = plt.colorbar(ticks=[0, 25, 50, 75, 100])
cbar.ax.set_yticklabels(['0%', '25%', '50%', '75%', '100%'])

# Set plot title and axis labels
plt.title(title, fontsize=16, fontweight='bold')
plt.xticks([0.5, 1.5, 2.5, 3.5], ["Abstract", "Realism", "Impressionism", "Cubism"], rotation=45)
plt.yticks([0.5, 1.5, 2.5, 3.5], yticklabels)

# ===================
# Part 4: Saving Output
# ===================
# Display the plot
plt.tight_layout()
plt.savefig("heatmap_117.pdf", bbox_inches="tight")
