
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Generate random data representing population density for heatmap
data = np.random.rand(8, 12) * 100  # Assuming population density per unit area
title = "Population Density Over Time"
xlabel = "Year"
ylabel = "City"
suptitle = "Population Density Visualization"
cbar_label = "Density (People per Unit Area)"
city_labels = [f"City {i+1}" for i in range(8)]
year_labels = [f"{2000 + i}" for i in range(12)]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a new figure
plt.figure(figsize=(10, 8))

# Set the supertitle of the figure
plt.suptitle(suptitle, fontsize=16, fontweight='bold')

# Set the title of the heatmap
plt.title(title, fontsize=14)

# Set the label for the x-axis
plt.xlabel(xlabel, fontsize=12)

# Set the label for the y-axis
plt.ylabel(ylabel, fontsize=12)

# Create a heatmap using pcolor function
c = plt.pcolor(data, edgecolors="w", linewidths=0.5, cmap="BuGn", vmin=0.0, vmax=100.0)

# Add a colorbar to the figure
cbar = plt.colorbar(c)
cbar.set_label(cbar_label, fontsize=12)

# Set the ticks and labels for the axes
plt.xticks(np.arange(0.5, len(year_labels), 1), year_labels, rotation=45, ha='right')
plt.yticks(np.arange(0.5, len(city_labels), 1), city_labels)

# Add gridlines for better readability
plt.grid(which='major', linewidth=0.5, linestyle='--', color='gray')

# ===================
# Part 4: Saving Output
# ===================
# Display the figure with tight layout to minimize white space
plt.tight_layout(rect=[0, 0.03, 1, 0.95])
plt.savefig("heatmap_118.pdf", bbox_inches="tight")
