
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Data in the heatmap
data = np.array(
    [
        [15.2, 20.1, 25.3, np.nan, 30.5],
        [10.5, 18.7, np.nan, 27.8, 33.1],
        [np.nan, 22.0, 28.3, 35.4, 40.0],
        [5.0, np.nan, 24.5, 29.6, 37.2],
        [8.2, 16.4, 21.9, np.nan, 32.8],
        [np.nan, 19.5, 26.7, 31.8, 38.5],
    ]
)

# Labels for the rows and columns
row_labels = ["Region 1", "Region 2", "Region 3", "Region 4", "Region 5", "Region 6"]
col_labels = ["City A", "City B", "City C", "City D", "City E"]

# Text labels and title
xlabel = "Cities"
ylabel = "Regions"
title = "Average Annual Temperatures (°C)"
suptitle = "Geographical Temperature Data"
annotations = "Temperatures"


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and the axes
fig, ax = plt.subplots(figsize=(8, 8))

# Create the heatmap
cax = ax.matshow(data, cmap="coolwarm")  # Updated colormap

# Set the ticks
ax.set_xticks(np.arange(len(col_labels)))
ax.set_yticks(np.arange(len(row_labels)))

# Set the tick labels
ax.set_xticklabels(col_labels)
ax.set_yticklabels(row_labels)

# Rotate the tick labels and set their alignment
plt.setp(ax.get_xticklabels(), rotation=45, ha="left", rotation_mode="anchor")

# Move the row labels to the right side
ax.yaxis.tick_right()

# Loop over data dimensions and create text annotations
for i in range(len(row_labels)):
    for j in range(len(col_labels)):
        if not np.isnan(data[i, j]):
            text = ax.text(
                j, i, f"{data[i, j]:.1f}", ha="center", va="center", color="black"
            )

# Set the visibility of the spines
ax.spines["top"].set_visible(True)
ax.spines["right"].set_visible(True)
ax.spines["left"].set_visible(False)
ax.spines["bottom"].set_visible(False)

# Set the visibility of the ticks with only the top and right axes
ax.xaxis.set_ticks_position("top")
ax.yaxis.set_ticks_position("right")

# Set labels and title
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.set_title(title, fontsize=14, pad=20)
fig.suptitle(suptitle, fontsize=16)


# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout(rect=[0, 0, 1, 0.95])
plt.savefig("heatmap_33.pdf", bbox_inches="tight")
