
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.colors as mcolors

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)
# Data in the heatmap
data = np.array(
    [
        [120, 300, 450, 600],
        [150, 320, 480, 620],
        [200, 330, 490, 630],
        [100, 310, 460, 610],
        [180, 305, 475, 615],
    ]
)

# Labels for rows and columns
row_labels = ["Netflix", "Hulu", "Amazon Prime", "Disney+", "HBO Max"]
column_labels = ["Q1", "Q2", "Q3", "Q4"]

title = "Monthly User Engagement Metrics - 2023"
xlabel = "Quarters"
ylabel = "Platforms"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Initialize the matplotlib figure
fig, ax = plt.subplots(figsize=(10, 7))

# Custom colormap
colors = ['#003f5c', '#374c80', '#7a5195', '#bc5090', '#ef5675', '#ff764a', '#ffa600']
cmap = mcolors.LinearSegmentedColormap.from_list("custom", colors)

# Draw the heatmap with the custom colormap
cax = ax.imshow(data, cmap=cmap)

# Set the title
ax.set_title(title, fontsize=20, weight='bold')

# Set labels for axes
ax.set_xlabel(xlabel, fontsize=16, weight='bold')
ax.set_ylabel(ylabel, fontsize=16, weight='bold')
ax.set_xticks(range(len(column_labels)))
ax.set_xticklabels(column_labels, fontsize=14, weight='bold')
ax.set_yticks(range(len(row_labels)))
ax.set_yticklabels(row_labels, fontsize=14, weight='bold')

# Add the text annotations
for i in range(len(row_labels)):
    for j in range(len(column_labels)):
        ax.text(j, i, f"{data[i, j]}", ha="center", va="center", color="white", fontsize=14, weight='bold')

# Create colorbar
cbar = fig.colorbar(cax, ax=ax)
cbar.ax.tick_params(labelsize=14, width=2, length=6)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to fit the figure size
plt.tight_layout()

# Show the plot
plt.savefig("heatmap_35.pdf", bbox_inches="tight")
