
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.colors as mcolors

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data in the heatmap
data = np.array(
    [
        [2.6, 1.5, 3.1, 2.0, 2.3, 1.8],
        [3.1, 3.2, 2.9, 3.0, 3.1, 2.7],
        [2.3, 2.4, 2.6, 2.5, 2.8, 2.9],
        [1.8, 2.1, 1.9, 2.0, 1.7, 1.5],
        [2.9, 3.0, 2.8, 2.7, 3.1, 2.5],
    ]
)

# Labels for rows and columns
row_labels = ["USA", "Germany", "China", "India", "Brazil"]
column_labels = ["2015", "2016", "2017", "2018", "2019", "2020"]

title = "Economic Growth Rate (GDP) for Selected Countries"
xlabel = "Year"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Initialize the matplotlib figure
f, ax = plt.subplots(figsize=(9, 6))

# Define the color scheme (Green to Red gradient)
color_list = ['#d73027', '#fc8d59', '#fee08b', '#d9ef8b', '#91cf60', '#1a9850']
cmap = mcolors.LinearSegmentedColormap.from_list("custom_cmap", color_list)

# Draw the heatmap
cax = ax.imshow(data, cmap=cmap)

# Set the title
ax.set_title(title, fontsize=18)

# Set labels for axes
ax.set_xlabel(xlabel, fontsize=18)
ax.set_xticks(range(len(column_labels)))
ax.set_xticklabels(column_labels)
ax.set_yticks(range(len(row_labels)))
ax.set_yticklabels(row_labels)

# Increase font size of the tick labels
ax.tick_params(axis="both", which="major", labelsize=14)

# Rotate the row labels to horizontal and set the font size
ax.set_yticklabels(ax.get_yticklabels(), rotation=0, fontsize=14)

# Add the text annotations
for i in range(len(row_labels)):
    for j in range(len(column_labels)):
        text = ax.text(
            j, i, data[i, j], ha="center", va="center", color="black", fontsize=14
        )

# Create colorbar
cbar = f.colorbar(cax, ax=ax)
cbar.ax.tick_params(labelsize=14)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to fit the figure size
plt.tight_layout()

# Show the plot
plt.savefig("heatmap_36.pdf", bbox_inches="tight")
