
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# New Data (correlation coefficients for political metrics)
data = np.array(
    [
        [np.nan, np.nan, np.nan, np.nan, np.nan, np.nan, np.nan, np.nan],
        [0.30, np.nan, np.nan, np.nan, np.nan, np.nan, np.nan, np.nan],
        [0.45, 0.50, np.nan, np.nan, np.nan, np.nan, np.nan, np.nan],
        [0.60, 0.40, 0.55, np.nan, np.nan, np.nan, np.nan, np.nan],
        [0.20, 0.30, 0.35, 0.50, np.nan, np.nan, np.nan, np.nan],
        [0.15, 0.10, 0.25, 0.30, 0.55, np.nan, np.nan, np.nan],
        [0.05, -0.10, 0.20, 0.15, 0.40, 0.60, np.nan, np.nan],
        [0.25, 0.35, 0.40, 0.45, 0.50, 0.55, 0.60, np.nan],
    ]
)

metrics = [
    "Approval Rating",
    "Economic Confidence",
    "Policy Support",
    "Public Sentiment",
    "Media Coverage",
    "Political Donations",
    "Election Polling",
    "Legislation Success",
]

xlabel = "Political Metrics"
ylabel = "Political Metrics"
title = "Correlation Heatmap of Political Metrics"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(10, 8))  # Adjusted for better readability

# Create heatmap with a customized color scheme
cax = ax.matshow(data, cmap="coolwarm")

# Add color bar
plt.colorbar(cax)

# Set axis labels
ax.set_xticks(np.arange(len(metrics)))
ax.set_yticks(np.arange(len(metrics)))
ax.set_xticklabels(metrics, fontsize=10)
ax.set_yticklabels(metrics, fontsize=10)

# Rotate the tick labels bottom and rotated to 90
ax.xaxis.set_ticks_position("bottom")
ax.xaxis.set_tick_params(rotation=90)

# Loop over data dimensions and create text annotations
for i in range(len(metrics)):
    for j in range(len(metrics)):
        if not np.isnan(data[i, j]):
            color = "black" if data[i, j] > 0.5 else "white"
            ax.text(j, i, f"{data[i, j]:.2f}", ha="center", va="center", color=color)

# Remove unnecessary spines
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.spines["left"].set_visible(False)
ax.spines["bottom"].set_visible(False)

# Add Title
plt.title(title, pad=20, fontsize=14, fontweight='bold')

# Add labels
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)

# Add gridlines for better readability
ax.grid(False)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("heatmap_54.pdf", bbox_inches="tight")
