
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Data for the heatmap (representing communication intensity between departments)
data = np.array(
    [
        [0.9, 0.3, 0.6, 0.2, 0.7],
        [0.4, 0.8, 0.5, 0.3, 0.6],
        [0.7, 0.4, 0.9, 0.1, 0.5],
        [0.2, 0.6, 0.3, 0.8, 0.4],
        [0.5, 0.7, 0.2, 0.4, 0.9],
    ]
)

# Departments' names for the axes
departments = ["HR", "IT", "Sales", "Marketing", "Finance"]
xlabel = "Departments"
ylabel = "Departments"
title = "Communication Intensity Between Departments"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the heatmap
fig, ax = plt.subplots(figsize=(8, 6))  # Adjusting figure size
cax = ax.matshow(data, cmap="coolwarm")

# Set the ticks and labels
ax.set_xticks(np.arange(len(departments)))
ax.set_yticks(np.arange(len(departments)))

# Adjust the tick label alignment to ensure the x-axis labels appear only at the bottom
ax.tick_params(
    axis="x", which="both", bottom=True, top=False, labelbottom=True, labeltop=False
)
ax.tick_params(axis="y", which="both", right=False, left=False, labelleft=True)

# Set the labels for the x-axis and rotate them for better readability
ax.set_xticklabels(departments, rotation=45)

# Set the labels for the y-axis
ax.set_yticklabels(departments)

# Add colorbar with the correct range
cbar = plt.colorbar(cax, ticks=[0, 0.2, 0.4, 0.6, 0.8, 1])
cbar.ax.set_yticklabels(
    ["0", "0.2", "0.4", "0.6", "0.8", "1"]
)  # Set the colorbar labels

# Add labels for the axes
plt.xlabel(xlabel)
plt.ylabel(ylabel)

# Adding title to the plot
plt.title(title, pad=20)

# ===================
# Part 4: Saving Output
# ===================
# Adjust the layout to add more space around the heatmap
plt.tight_layout()

# Show the plot
plt.savefig("heatmap_61.pdf", bbox_inches="tight")
