
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Placeholder data for philosophy-related matrices
data_classical = np.array(
    [
        [30, 5, 10, 0, 0, 0],
        [15, 35, 5, 5, 0, 0],
        [8, 7, 20, 10, 10, 0],
        [0, 0, 5, 25, 5, 5],
        [0, 0, 8, 10, 22, 5],
        [0, 0, 0, 8, 10, 15],
    ]
)
data_modern = np.array(
    [
        [5, 0, 0, 15, 5, 0],
        [0, 7, 5, 10, 8, 0],
        [0, 0, 12, 9, 10, 10],
        [10, 5, 0, 0, 5, 5],
        [15, 8, 0, 0, 10, 10],
        [10, 15, 20, 0, 5, 7],
    ]
)

# Titles for the subplots
titles = ["Classical Philosophy", "Modern Philosophy"]
ylabel = "Philosophical School"
xlabel = "Predicted Category"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Increase the figure height and adjust subplot layout
fig, axes = plt.subplots(nrows=1, ncols=2, figsize=(6, 5))


# Function to create a single confusion matrix plot
def plot_confusion_matrix(ax, data, title):
    im = ax.imshow(data, interpolation="nearest", cmap="Blues")
    ax.set(
        title=title,
        ylabel=ylabel,
        xlabel=xlabel,
        xticks=np.arange(data.shape[1]),
        yticks=np.arange(data.shape[0]),
    )
    ax.axhline(y=2.5, color="black", linewidth=2.5, linestyle='--')
    ax.axvline(x=2.5, color="black", linewidth=2.5, linestyle='--')
    # unset the ticks
    ax.set_xticks([])
    ax.set_yticks([])
    # unset the spines
    ax.spines["top"].set_visible(False)
    ax.spines["right"].set_visible(False)
    ax.spines["bottom"].set_visible(False)
    ax.spines["left"].set_visible(False)
    return im


# Plot each confusion matrix
im1 = plot_confusion_matrix(axes[0], data_classical, titles[0])
im2 = plot_confusion_matrix(axes[1], data_modern, titles[1])

# Adjust the position and size of the colorbars
cbar_ax1 = fig.add_axes([0.05, 0.15, 0.45, 0.02])  # Adjusted for the first subplot
cbar_ax2 = fig.add_axes([0.55, 0.15, 0.45, 0.02])  # Adjusted for the second subplot
fig.colorbar(im1, cax=cbar_ax1, orientation="horizontal")
fig.colorbar(im2, cax=cbar_ax2, orientation="horizontal")

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
fig.tight_layout()
plt.savefig("heatmap_64.pdf", bbox_inches="tight")
