
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Seed for reproducibility
np.random.seed(0)
# Define labels and title
regions = [
    "Urban",
    "Suburban",
    "Rural",
    "Coastal",
    "Mountain",
    "Desert",
    "Forest",
    "Industrial",
    "Touristic",
    "Remote",
]
technologies = [
    "Electric Vehicles",
    "Autonomous Vehicles",
    "High-Speed Rail",
    "Hyperloop",
    "Drone Delivery",
]
title = "Adoption of Transportation Technologies Across Regions"
xlabel = "Technologies"
ylabel = "Regions"



# Generate data
data = np.random.rand(10, 5) * 100  # Random data as percentage of adoption

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the heatmap
fig, ax = plt.subplots(figsize=(8, 12))  # Adjusting figure size

# Custom color map
cax = ax.matshow(data, cmap="YlGnBu", vmin=0, vmax=100)

# Set axis labels
ax.set_xticks(np.arange(len(technologies)))
ax.set_yticks(np.arange(len(regions)))
ax.set_xticklabels(technologies)
ax.set_yticklabels(regions)

# Rotate the tick labels and set their alignment
plt.setp(ax.get_xticklabels(), rotation=270, ha="center")

# Add colorbar
cbar = plt.colorbar(cax, aspect=10.5)
cbar.set_label('% Adoption Rate', rotation=270, labelpad=20)

# Additional Texts
ax.set_title(title, pad=20)
plt.xlabel(xlabel)
plt.ylabel(ylabel)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot
plt.tight_layout()
plt.savefig("heatmap_70.pdf", bbox_inches="tight")

# Display plot
