
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)

# Sample data for finance domain
data = np.random.rand(10, 5) * 200 - 100  # Random data simulating financial variations

sectors = [
    "Banking",
    "Investment",
    "Insurance",
    "Real Estate",
    "FinTech",
    "Retail",
    "Consumer Goods",
    "Healthcare",
    "Energy",
    "Technology",
]

metrics = ["Growth%", "Risk Index", "Revenue", "Net Profit", "ROE"]

# Text labels and titles
xlabel = 'Financial Metrics'
ylabel = 'Financial Sectors'
title = 'Financial Sector Metrics Heatmap'
cbar_label = 'Value Range'

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the heatmap
fig, ax = plt.subplots(figsize=(8, 10))  # Adjusting figure size

# Selecting a custom color map for finance domain
cax = ax.matshow(data, cmap="RdYlGn", vmin=-100, vmax=100)

# Set axis labels
ax.set_xticks(np.arange(len(metrics)))
ax.set_yticks(np.arange(len(sectors)))
ax.set_xticklabels(metrics)
ax.set_yticklabels(sectors)

# Rotate the tick labels and set their alignment
plt.setp(ax.get_xticklabels(), rotation=45, ha="right")

# Add colorbar with custom label
cbar = plt.colorbar(cax, aspect=10.5, pad=0.03)
cbar.set_label(cbar_label)

# Adding titles and labels
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title, pad=20)

# ===================
# Part 4: Saving Output
# ===================
# Showing the plot and saving as a PDF
plt.tight_layout()
plt.savefig("heatmap_71.pdf", bbox_inches="tight")
