
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Synthetic sentiment analysis data
data = np.array(
    [
        [0, 2, 4, 6, 8, 10],
        [np.nan, 1, 3, 5, 7, 9],
        [np.nan, np.nan, 2, 4, 6, 8],
        [np.nan, np.nan, np.nan, 3, 5, 7],
        [np.nan, np.nan, np.nan, np.nan, 4, 6],
        [np.nan, np.nan, np.nan, np.nan, np.nan, 5],
    ]
)
colorbar_label = "Sentiment Score"
xlabel = "To Analysis Stage"
ylabel = "Start Analysis from Stage"
textstr = "Sentiment Trend\n(Scale 1 to 10)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and axis
fig, ax = plt.subplots(figsize=(6, 8))

# Create the heatmap with a different color map
cax = ax.matshow(data, cmap="coolwarm")

# Add colorbar with modified label and shrink parameter
cbar = fig.colorbar(cax, label=colorbar_label, shrink=0.5)

# Set axis labels
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)

# Set axis ticks
ax.set_xticks(np.arange(6))
ax.set_yticks(np.arange(6))
ax.set_xticklabels([1, 2, 3, 4, 5, ""])
ax.set_yticklabels([1, 2, 3, 4, 5, ""])

# Add text box with a different style
props = dict(
    boxstyle="round,pad=0.3",
    edgecolor="black",
    facecolor="#eafff5",
    alpha=0.8
)
ax.text(
    0.05,
    0.15,
    textstr,
    transform=ax.transAxes,
    fontsize=12,
    verticalalignment="top",
    bbox=props,
)

# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("heatmap_74.pdf", bbox_inches="tight")
