
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import pandas as pd

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Defining the categories
categories = ["Offense", "Defense", "Stamina", "Teamwork"]

# Generating random data for illustration purposes
# You will need to replace this with your actual data
data = np.random.uniform(50, 100, size=(140,))  # Performance stats between 50 and 100 for 140 events

# Creating a DataFrame
df = pd.DataFrame(
    {
        "Categories": np.tile(categories, 35),  # Repeating each category 35 times
        "Game": np.repeat(range(1, 36), 4),  # Repeating game numbers from 1-35, 4 times
        "Performance": data,
    }
)

# Pivoting the DataFrame to get it into matrix form
pivot_df = df.pivot(index="Categories", columns="Game", values="Performance")

# Reordering the index of the pivot_df to match the desired order
pivot_df = pivot_df.reindex(categories)

color_bar_label = "Performance Score"  # Label for the color bar

# Text label parameters
xlabel = "Game"
ylabel = "Categories"
title = "Team Performance Metrics Across Games"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(12, 4))  # Adjust size as needed

# Choosing a sports-themed colormap, e.g., 'plasma'
cmap = plt.get_cmap("plasma")
cax = plt.imshow(pivot_df, cmap=cmap)

# Setting x-ticks to 0, 5, 10, ... 35
plt.xticks(np.arange(0, 36, 5), range(0, 36, 5))
plt.yticks(range(len(categories)), categories)

plt.yticks(rotation=0)  # Ensure y-tick labels are horizontal
plt.xticks(rotation=0)  # Ensure x-tick labels are horizontal

# Add colorbar
cbar = plt.colorbar(cax)
cbar.set_label(color_bar_label)

# Adding title and labels
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("heatmap_81.pdf", bbox_inches="tight")
