
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data for the heatmaps (generated for literature domain)
data_fiction = np.random.rand(4, 4)
data_nonfiction = np.random.rand(4, 4)
data_scifi = np.random.rand(4, 4)
data_fantasy = np.random.rand(4, 4)
titles = ["Fiction", "Non-Fiction", "Science Fiction", "Fantasy"]
fig_title = "Popularity of Literary Genres by Decade"
x_tick_labels = ["1970s", "1980s", "1990s", "2000s"]
y_tick_labels = ["1970s", "1980s", "1990s", "2000s"]
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with subplots
fig, axs = plt.subplots(2, 2, figsize=(10, 8))


# Function to add text annotations
def add_annotations(ax, data):
    for i in range(data.shape[0]):
        for j in range(data.shape[1]):
            ax.text(j, i, f"{data[i, j]:.2f}", ha="center", va="center", color="black", fontsize=9, fontweight='bold')


# Fiction heatmap
im1 = axs[0, 0].imshow(data_fiction, cmap="Blues", vmin=0, vmax=1)
axs[0, 0].set_title(titles[0], fontweight='bold')
add_annotations(axs[0, 0], data_fiction)

# Non-Fiction heatmap
im2 = axs[0, 1].imshow(data_nonfiction, cmap="Greens", vmin=0, vmax=1)
axs[0, 1].set_title(titles[1], fontweight='bold')
add_annotations(axs[0, 1], data_nonfiction)

# Science Fiction heatmap
im3 = axs[1, 0].imshow(data_scifi, cmap="Blues", vmin=0, vmax=1)
axs[1, 0].set_title(titles[2], fontweight='bold')
add_annotations(axs[1, 0], data_scifi)

# Fantasy heatmap
im4 = axs[1, 1].imshow(data_fantasy, cmap="Greens", vmin=0, vmax=1)
axs[1, 1].set_title(titles[3], fontweight='bold')
add_annotations(axs[1, 1], data_fantasy)

# Adjust layout and add overall title
fig.suptitle(fig_title, fontsize=18, fontweight='bold')

# Set tick labels
for ax in axs.flat:
    ax.set_xticks(np.arange(4))
    ax.set_yticks(np.arange(4))
    ax.set_xticklabels(x_tick_labels)
    ax.set_yticklabels(y_tick_labels)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to minimize white space
plt.tight_layout(rect=[0, 0, 1, 0.95])
# Save the figure to a file
plt.savefig("heatmap_84.pdf", bbox_inches="tight")
