
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import pandas as pd

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Define the pollutant labels
pollutants = [
    "CO2",
    "CH4",
    "NOx",
    "SO2",
    "PM2.5",
    "PM10",
    "O3",
    "CO",
]

# Define the data for the pre-intervention and post-intervention values
pre_intervention_values = [400, 1.8, 0.25, 0.02, 35, 50, 0.04, 0.6]
post_intervention_values = [380, 1.5, 0.20, 0.015, 30, 45, 0.03, 0.5]
titles = ["Pre-Intervention", "Post-Intervention"]

xlabel = "Pollutants"
ylabel = ""
annotation_color = "black"
supertitle = "Pollutant Levels Pre and Post Intervention"
colormap = "YlGnBu"  # Chosen for environmental themes

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with two subplots (one for pre-intervention and one for post-intervention values)
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(10, 5))

# Define the color palette
cmap = plt.get_cmap(colormap)

# Plot heatmap for pre-intervention values
im1 = ax1.imshow(pd.DataFrame([pre_intervention_values], columns=pollutants), cmap=cmap)
ax1.set_title(titles[0])
ax1.set_xticks(range(len(pollutants)))
ax1.set_xticklabels(pollutants, rotation=45, ha="center")
ax1.set_yticks(range(1))
ax1.set_yticklabels([ylabel], rotation=0)

# Add annotations for pre-intervention values
for i in range(1):
    for j in range(len(pollutants)):
        ax1.text(
            j, i, f"{pre_intervention_values[j]:.2f}", ha="center", va="center", color=annotation_color
        )

# Plot heatmap for post-intervention values
im2 = ax2.imshow(pd.DataFrame([post_intervention_values], columns=pollutants), cmap=cmap)
ax2.set_title(titles[1])
ax2.set_xticks(range(len(pollutants)))
ax2.set_xticklabels(pollutants, rotation=45, ha="center")
ax2.set_yticks(range(1))
ax2.set_yticklabels([ylabel], rotation=0)

# Add annotations for post-intervention values
for i in range(1):
    for j in range(len(pollutants)):
        ax2.text(
            j, i, f"{post_intervention_values[j]:.2f}", ha="center", va="center", color=annotation_color
        )

# Display the figure
plt.subplots_adjust(hspace=0.4)
plt.suptitle(supertitle)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout(rect=[0, 0, 1, 0.96])
plt.savefig("heatmap_88.pdf", bbox_inches="tight")
