
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import pandas as pd

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Define the subject labels
subjects = [
    "Math",
    "Science",
    "History",
    "Art",
    "Physical Education",
    "Music",
    "Literature",
    "Technology"
]

# Define the data for the original and adjusted values
original_scores = [75, 80, 65, 70, 90, 85, 60, 78]
adjusted_scores = [82, 88, 72, 75, 92, 87, 68, 85]
titles = ["Scores Before Intervention", "Scores After Intervention"]

# Chart text labels
xlabel = "Subjects"
ylabel = "Students"
annotation_format = "{:.0f}"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with two subplots (one for original and one for adjusted values)
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(10, 8))

# Define a new color palette
cmap = plt.get_cmap("viridis")

# Plot heatmap for original values
im1 = ax1.imshow(pd.DataFrame([original_scores], columns=subjects), cmap=cmap, aspect='auto')
ax1.set_title(titles[0])
ax1.set_xticks(range(len(subjects)))
ax1.set_xticklabels(subjects, rotation=45, ha="right")
ax1.set_yticks(range(1))
ax1.set_xlabel(xlabel)
ax1.set_yticklabels([""], rotation=0)

# Add annotations for original values
for i in range(1):
    for j in range(len(subjects)):
        ax1.text(
            j, i, annotation_format.format(original_scores[j]), ha="center", va="center", color="white"
        )

# Plot heatmap for adjusted values
im2 = ax2.imshow(pd.DataFrame([adjusted_scores], columns=subjects), cmap=cmap, aspect='auto')
ax2.set_title(titles[1])
ax2.set_xticks(range(len(subjects)))
ax2.set_xticklabels(subjects, rotation=45, ha="right")
ax2.set_yticks(range(1))
ax2.set_xlabel(xlabel)
ax2.set_yticklabels([""], rotation=0)

# Add annotations for adjusted values
for i in range(1):
    for j in range(len(subjects)):
        ax2.text(
            j, i, annotation_format.format(adjusted_scores[j]), ha="center", va="center", color="white"
        )

# Display the figure
plt.subplots_adjust(hspace=-0.4)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("heatmap_90.pdf", bbox_inches="tight")

