
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)  # For reproducibility

# Simulating data for scientific experiments
sizes = np.linspace(300, 100, 6, dtype=int)  # Generate sizes from 300 to 100
data = [
    np.abs(np.random.normal(0, 0.4, size)) for size in sizes
]  # Generate data with mean 0 and take absolute value

# Labels for different scientific experiments
labels = [
    "Experiment A",
    "Experiment B",
    "Experiment C",
    "Experiment D",
    "Experiment E",
    "Experiment F",
]
xlabel = "Deviation from Expected Outcome"
ylabel = "Number of Observations"
xlim = [0, 1.2]
xticks = [0.0, 0.2, 0.4, 0.6, 0.8, 1.0, 1.2]
bins = 30

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Histogram plot
colors = ["#72B7B2", "#FFB347", "#FF6961", "#AEC6CF", "#CFCFC4", "#77DD77"]

plt.figure(figsize=(10, 8))
plt.hist(
    data,
    bins=bins,
    stacked=True,
    edgecolor="white",
    linewidth=1.2,
    color=colors,
    label=labels,
    hatch="//",  # Adding hatch pattern for better visualization
)

# Set background color to white
ax = plt.gca()
ax.set_facecolor("white")

# Labels and title
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.xlim(xlim)
plt.xticks(xticks)
plt.title("Deviation Analysis Across Different Scientific Experiments")
handles, labels = plt.gca().get_legend_handles_labels()

# Reverse handles and labels
handles = handles[::-1]
labels = labels[::-1]

plt.legend(handles, labels, loc="upper right")

# ===================
# Part 4: Saving Output
# ===================
# Adjusting the plot to match the original image's dimensions
plt.tight_layout()
plt.savefig("hist_23.pdf", bbox_inches="tight")
