
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Simulating data for population growth rates
sizes = np.linspace(250, 100, 4, dtype=int) 

data1 = np.abs(np.random.normal(1.2, 0.2, sizes[0]))  # Country A
data2 = np.abs(np.random.normal(1.5, 0.2, sizes[1]))  # Country B
data3 = np.abs(np.random.normal(1.0, 0.2, sizes[2]))  # Country C
data4 = np.abs(np.random.normal(0.8, 0.2, sizes[3]))  # Country D
labels = [
    "Country A",
    "Country B",
    "Country C",
    "Country D",
]
xlabel = "Annual Growth Rate (%)"
ylabel = "Frequency"
title = "Distribution of Population Growth Rates"
bins = np.linspace(0.0, 2.0, 20)  # Adjusted bins to fit data range

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Histogram plot

colors = ["#8bc34a", "#ff9800", "#03a9f4", "#e91e63"]

plt.figure(figsize=(10, 7))  # Adjusting for better visual representation

plt.hist(
    [data1, data2, data3, data4],
    bins=bins,
    stacked=True,
    label=labels,
    color=colors,
    edgecolor="black",
    alpha=0.75  # Adding some transparency
)

# Labels and title
plt.xlabel(xlabel, fontsize=12)
plt.ylabel(ylabel, fontsize=12)
plt.title(title, fontsize=14)
plt.legend(title="Countries")

# Adding grid to enhance readability
plt.grid(True, linestyle='--', alpha=0.6)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("hist_24.pdf", bbox_inches="tight")
