
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Simulating temperature data (in degrees Celsius)
sizes = np.linspace(250, 100, 4, dtype=int)  # Generate sizes for data arrays

data_city1 = np.abs(np.random.normal(15, 5, sizes[0]))  # City 1: Mild Climate
data_city2 = np.abs(np.random.normal(25, 7, sizes[1]))  # City 2: Warm Climate
data_city3 = np.abs(np.random.normal(5, 3, sizes[2]))   # City 3: Cold Climate
data_city4 = np.abs(np.random.normal(30, 10, sizes[3])) # City 4: Hot Climate
labels = ["Mild Climate City", "Warm Climate City", "Cold Climate City", "Hot Climate City"]
xlabel = "Temperature (°C)"
ylabel = "Frequency"
bins = np.linspace(0, 50, 20)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728"]

plt.figure(figsize=(10, 7))  # Adjusted for better readability

plt.hist(
    [data_city1, data_city2, data_city3, data_city4],
    bins=bins,
    stacked=True,
    label=labels,
    color=colors,
    edgecolor="black",
)

# Labels and title
plt.xlabel(xlabel, fontsize=12)
plt.ylabel(ylabel, fontsize=12)
plt.title("Temperature Distribution Across Different Cities", fontsize=14)
plt.legend(loc="upper right")

# Adding grid for better readability
plt.grid(True, linestyle='--', linewidth=0.5)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("hist_25.pdf", bbox_inches="tight")

