
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Simulating data
sizes = np.linspace(500, 200, 4, dtype=int)  # Generate sizes for different dataset sizes

data_python = np.abs(np.random.normal(0.6, 0.15, sizes[0]))
data_js = np.abs(np.random.normal(0.75, 0.1, sizes[1]))
data_java = np.abs(np.random.normal(0.7, 0.12, sizes[2]))
data_cpp = np.abs(np.random.normal(0.65, 0.1, sizes[3]))

labels = ["Python", "JavaScript", "Java", "C++"]
xlabel = "Usage Percentage"
ylabel = "Frequency"
bins = np.linspace(0.2, 1.0, 20)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Histogram plot

colors = ["#f08080", "#87cefa", "#98fb98", "#dda0dd"]

plt.figure(figsize=(10, 6))  # Adjusted the size for better visibility and aesthetics

plt.hist(
    [data_python, data_js, data_java, data_cpp],
    bins=bins,
    stacked=True,
    label=labels,
    color=colors,
    edgecolor="black",
    alpha=0.75,  # Adding some transparency for better visibility
)

# Labels and title
plt.xlabel(xlabel, fontsize=12)
plt.ylabel(ylabel, fontsize=12)
plt.title("Programming Language Usage Statistics", fontsize=14)
plt.legend()

# Adding grid lines for better readability
plt.grid(axis='y', linestyle='--', alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("hist_26.pdf", bbox_inches="tight")
